#!/bin/bash
for i in "$@"
do
case $i in
  --app-path=*)
    APP_PATH="${i#*=}"
    shift
    ;;
  --bak-path=*)
    BAK_PATH="${i#*=}"
    shift
    ;;
  --update-path=*)
    UPDATE_PATH="${i#*=}"
    shift
    ;;
  --launch-path=*)
    LAUNCH_PATH="${i#*=}"
    shift
    ;;
  --runner=*)
    RUNNER="${i#*=}"
    shift
    ;;
  --verbose=*)
    VERBOSE="${i#*=}"
    shift
    ;;
    *)
            # unknown option
    ;;
esac
done
rsync -al$VERBOSE --delete "$APP_PATH/." "$BAK_PATH/"
rsync -al$VERBOSE "$UPDATE_PATH/." "$APP_PATH/"
cd $LAUNCH_PATH
"$APP_PATH/${RUNNER}" &
