"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.createRuntime = exports.ServerMethods = void 0;
const runtime_folder_1 = __importDefault(require("@postman/runtime.folder"));
const runtime_collection_1 = __importDefault(require("@postman/runtime.collection"));
const GRPCClient = __importStar(require("@postman/runtime.grpc-client"));
const MQTTClient = __importStar(require("@postman/runtime.mqtt-client"));
const SocketIOClient = __importStar(require("@postman/runtime.socket.io-client"));
const WebsocketClient = __importStar(require("@postman/runtime.websocket-client"));
const runtime_grpc_request_1 = __importDefault(require("@postman/runtime.grpc-request"));
const complete_runtime_1 = __importDefault(require("./complete-runtime"));
const runtime_mqtt_request_1 = __importDefault(require("@postman/runtime.mqtt-request"));
const runtime_socket_io_request_1 = __importDefault(require("@postman/runtime.socket.io-request"));
const runtime_websocket_request_1 = __importDefault(require("@postman/runtime.websocket-request"));
var server_methods_1 = require("./server-methods");
Object.defineProperty(exports, "ServerMethods", { enumerable: true, get: function () { return server_methods_1.ServerMethods; } });
function createRuntime(config) {
    const runtime = new complete_runtime_1.default();
    runtime.registerType(runtime_folder_1.default.use());
    runtime.registerType(runtime_collection_1.default.use());
    runtime.registerExecutableType(runtime_grpc_request_1.default.use().implement({
        invoke: (options) => GRPCClient.invoke(options),
        resolveSchema: config?.grpcRequest?.resolveSchema || (() => { }),
    }));
    runtime.registerExecutableType(runtime_mqtt_request_1.default.use().implement({
        connect: (options) => MQTTClient.connect(options),
    }));
    runtime.registerExecutableType(runtime_websocket_request_1.default.use().implement({
        connect: (options) => WebsocketClient.connect(options),
    }));
    runtime.registerExecutableType(runtime_socket_io_request_1.default.use().implement({
        connect: (options) => SocketIOClient.connect(options),
    }));
    return runtime;
}
exports.createRuntime = createRuntime;
//# sourceMappingURL=runtime.js.map