import { FromSchema } from 'json-schema-to-ts';
import { Event } from '@postman/runtime.core';
import { MessageType, MessageSubType } from './utils/mime-types';
declare const definition: {
    connected: {
        schema: {
            type: "object";
            properties: {
                handshakeRequest: {
                    type: "object";
                    required: ["method", "headers", "url"];
                    properties: {
                        method: {
                            type: "string";
                            enum: ["GET", "CONNECT"];
                        };
                        headers: {
                            type: "array";
                            items: {
                                type: "object";
                                required: ["key", "value"];
                                properties: {
                                    key: {
                                        type: "string";
                                    };
                                    value: {
                                        type: "string";
                                    };
                                };
                                additionalProperties: false;
                            };
                        };
                        url: {
                            type: "string";
                        };
                    };
                    additionalProperties: false;
                };
                handshakeResponse: {
                    type: "object";
                    required: ["statusCode", "statusMessage", "headers"];
                    properties: {
                        statusCode: {
                            type: "integer";
                            minimum: 100;
                            maximum: 599;
                        };
                        statusMessage: {
                            type: "string";
                        };
                        headers: {
                            type: "array";
                            items: {
                                type: "object";
                                required: ["key", "value"];
                                properties: {
                                    key: {
                                        type: "string";
                                    };
                                    value: {
                                        type: "string";
                                    };
                                };
                                additionalProperties: false;
                            };
                        };
                    };
                    additionalProperties: false;
                };
            };
            additionalProperties: false;
        };
    };
    disconnected: {
        schema: {
            type: "object";
            properties: {
                code: {
                    type: "integer";
                    minimum: 1000;
                    maximum: 4999;
                };
                reason: {
                    type: "string";
                };
            };
            additionalProperties: false;
        };
    };
    error: {
        schema: {
            type: "object";
            required: ["error"];
            properties: {
                error: {
                    type: "object";
                    required: ["message"];
                    properties: {
                        message: {
                            type: "string";
                        };
                    };
                    additionalProperties: false;
                };
                handshakeRequest: {
                    type: "object";
                    required: ["method", "headers", "url"];
                    properties: {
                        method: {
                            type: "string";
                            enum: ["GET", "CONNECT"];
                        };
                        headers: {
                            type: "array";
                            items: {
                                type: "object";
                                required: ["key", "value"];
                                properties: {
                                    key: {
                                        type: "string";
                                    };
                                    value: {
                                        type: "string";
                                    };
                                };
                                additionalProperties: false;
                            };
                        };
                        url: {
                            type: "string";
                        };
                    };
                    additionalProperties: false;
                };
                handshakeResponse: {
                    type: "object";
                    required: ["statusCode", "statusMessage", "headers"];
                    properties: {
                        statusCode: {
                            type: "integer";
                            minimum: 100;
                            maximum: 599;
                        };
                        statusMessage: {
                            type: "string";
                        };
                        headers: {
                            type: "array";
                            items: {
                                type: "object";
                                required: ["key", "value"];
                                properties: {
                                    key: {
                                        type: "string";
                                    };
                                    value: {
                                        type: "string";
                                    };
                                };
                                additionalProperties: false;
                            };
                        };
                    };
                    additionalProperties: false;
                };
            };
            additionalProperties: false;
        };
    };
    reconnecting: {
        schema: {
            type: "object";
            additionalProperties: false;
        };
    };
    aborted: {
        schema: {
            type: "object";
            additionalProperties: false;
        };
    };
    'sent-message': {
        schema: {
            type: "object";
            required: ["data"];
            properties: {
                data: {
                    type: "object";
                    required: ["type", "payload"];
                    properties: {
                        type: {
                            type: "string";
                        };
                        payload: {
                            type: "string";
                        };
                    };
                    additionalProperties: false;
                };
                mimeType: {
                    type: "string";
                };
                size: {
                    type: "integer";
                    minimum: 0;
                };
                fileExtension: {
                    type: "string";
                };
            };
            additionalProperties: false;
        };
    };
    'received-message': {
        schema: {
            type: "object";
            required: ["data"];
            properties: {
                data: {
                    type: "object";
                    required: ["type", "payload"];
                    properties: {
                        type: {
                            type: "string";
                        };
                        payload: {
                            type: "string";
                        };
                    };
                    additionalProperties: false;
                };
                mimeType: {
                    type: "string";
                };
                size: {
                    type: "integer";
                    minimum: 0;
                };
                fileExtension: {
                    type: "string";
                };
            };
            additionalProperties: false;
        };
    };
};
export type Connected = Event<'connected', FromSchema<(typeof definition)['connected']['schema']>>;
export type Error = Event<'error', FromSchema<(typeof definition)['error']['schema']>>;
export type Disconnected = Event<'disconnected', FromSchema<(typeof definition)['disconnected']['schema']>>;
export type Reconnecting = Event<'reconnecting', FromSchema<(typeof definition)['reconnecting']['schema']>>;
export type Aborted = Event<'aborted', FromSchema<(typeof definition)['aborted']['schema']>>;
export type SentMessage = Event<'sent-message', FromSchema<(typeof definition)['sent-message']['schema']>>;
export type ReceivedMessage = Event<'received-message', FromSchema<(typeof definition)['received-message']['schema']>>;
export type Publish = Event<'publish', {
    payload: string;
    messageType: Exclude<MessageType, MessageType.BINARY>;
} | {
    payload: string;
    messageType: MessageType.BINARY;
    messageSubType: MessageSubType;
}>;
export type Close = Event<'close', {
    code?: number;
    reason?: string;
}>;
export {};
