/// <reference types="node" />
import { ConnectionEndEvent, ErrorEvent, CloseEvent, ReconnectEvent, OpenEvent, UpgradeEvent, MessageEvent } from './connection-events';
import type { SecureContextOptions } from '@postman/runtime.core';
export interface WebsocketAgent {
    connect(options: ConnectionOptions): WebsocketConnection | Promise<WebsocketConnection>;
}
export interface WebsocketConnection {
    send(payload: string | Uint8Array): void;
    close(code?: number, reason?: string): void;
    on(eventName: 'close', listener: (event: CloseEvent) => void): this;
    on(eventName: 'end', listener: (event: ConnectionEndEvent) => void): this;
    on(eventName: 'error', listener: (event: ErrorEvent) => void): this;
    on(eventName: 'message', listener: (event: MessageEvent) => void): this;
    on(eventName: 'reconnect', listener: (event: ReconnectEvent) => void): this;
    on(eventName: 'upgrade', listener: (event: UpgradeEvent) => void): this;
    on(eventName: 'open', listener: (event: OpenEvent) => void): this;
}
export interface ConnectionOptions {
    url: string | URL;
    connectOptions?: {
        handshakeTimeout?: number;
        maxPayload?: number;
        followRedirects?: boolean;
    };
    reconnectOptions?: {
        retryCount?: number;
        retryDelay?: number;
    };
    protocols?: string | string[];
    tlsOptions?: TLSOptions;
    headers: Record<string, string>;
}
export interface TLSOptions {
    rejectUnauthorized?: boolean;
    secureContext?: SecureContextOptions;
}
