"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __exportStar = (this && this.__exportStar) || function(m, exports) {
    for (var p in m) if (p !== "default" && !Object.prototype.hasOwnProperty.call(exports, p)) __createBinding(exports, m, p);
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.SocketIOEvents = void 0;
const json_schema_to_ts_1 = require("json-schema-to-ts");
const runtime_core_1 = require("@postman/runtime.core");
const runtime_documentation_1 = __importDefault(require("@postman/runtime.documentation"));
const runtime_variables_1 = __importDefault(require("@postman/runtime.variables"));
const handler_1 = __importDefault(require("./handler"));
exports.SocketIOEvents = __importStar(require("./events"));
__exportStar(require("./agent"), exports);
const definition = (0, json_schema_to_ts_1.asConst)({
    name: 'ws-socketio-request',
    summary: 'Socket.IO Request',
    schema: {
        type: 'object',
        properties: {
            url: {
                type: 'string',
            },
            headers: {
                type: 'array',
                items: {
                    type: 'object',
                    required: ['key', 'value'],
                    properties: {
                        key: {
                            type: 'string',
                        },
                        value: {
                            type: 'string',
                        },
                        description: {
                            type: 'string',
                        },
                        disabled: {
                            type: 'boolean',
                        },
                    },
                    additionalProperties: false,
                },
            },
            queryParams: {
                type: 'array',
                items: {
                    type: 'object',
                    required: ['key', 'value'],
                    properties: {
                        key: {
                            type: ['string', 'null'],
                        },
                        value: {
                            type: ['string', 'null'],
                        },
                        description: {
                            type: 'string',
                        },
                        disabled: {
                            type: 'boolean',
                        },
                    },
                    additionalProperties: false,
                },
            },
            settings: {
                type: 'object',
                properties: {
                    version: {
                        type: 'string',
                        enum: ['2', '3', '4'],
                    },
                    path: {
                        type: 'string',
                    },
                    handshakeTimeout: {
                        type: 'integer',
                        minimum: 0,
                    },
                    retryCount: {
                        type: 'integer',
                        minimum: 0,
                    },
                    retryDelay: {
                        type: 'integer',
                        minimum: 0,
                    },
                    strictSSL: {
                        type: 'boolean',
                    },
                },
                additionalProperties: false,
            },
            events: {
                type: 'array',
                items: {
                    type: 'object',
                    required: ['name'],
                    properties: {
                        name: {
                            type: 'string',
                        },
                        description: {
                            type: 'string',
                        },
                        subscribeOnConnect: {
                            type: 'boolean',
                        },
                    },
                    additionalProperties: false,
                },
            },
        },
        additionalProperties: false,
    },
    constraints: [
        {
            constraint: 'allow-child-types',
            allowed: ['ws-socketio-message'],
        },
        {
            constraint: 'allow-extensions',
            allowed: ['documentation', 'variables'],
        },
    ],
});
const extensions = [
    runtime_documentation_1.default.use().implement({}),
    runtime_variables_1.default.use().implement({
        replaceInFields: [
            'payload.url',
            'payload.headers',
            'payload.queryParams',
            'payload.events',
            'payload.settings',
        ],
    }),
];
var SocketIORequest;
(function (SocketIORequest) {
    SocketIORequest.use = runtime_core_1.ItemType.define(definition, extensions, handler_1.default);
})(SocketIORequest || (SocketIORequest = {}));
exports.default = SocketIORequest;
//# sourceMappingURL=index.js.map