import { FromSchema } from 'json-schema-to-ts';
import { Event } from '@postman/runtime.core';
import { MqttMessage, SubscriptionMessage } from '@postman/runtime.mqtt-utils';
declare const definition: {
    connected: {
        schema: {
            readonly type: "object";
            readonly properties: {
                readonly packet: {
                    readonly type: "object";
                    readonly required: ["cmd", "sessionPresent"];
                    readonly properties: {
                        readonly cmd: {
                            readonly type: "string";
                            readonly enum: readonly ["connack"];
                        };
                        readonly messageId: {
                            readonly type: "number";
                        };
                        readonly dup: {
                            readonly type: "boolean";
                        };
                        readonly length: {
                            readonly type: "number";
                        };
                        readonly returnCode: {
                            readonly type: "number";
                        };
                        readonly reasonCode: {
                            readonly type: "number";
                        };
                        readonly sessionPresent: {
                            readonly type: "boolean";
                        };
                        readonly properties: {
                            readonly type: "object";
                            readonly properties: {
                                readonly sessionExpiryInterval: {
                                    readonly type: "number";
                                };
                                readonly receiveMaximum: {
                                    readonly type: "number";
                                };
                                readonly maximumQoS: {
                                    readonly type: "number";
                                };
                                readonly retainAvailable: {
                                    readonly type: "boolean";
                                };
                                readonly maximumPacketSize: {
                                    readonly type: "number";
                                };
                                readonly assignedClientIdentifier: {
                                    readonly type: "string";
                                };
                                readonly topicAliasMaximum: {
                                    readonly type: "number";
                                };
                                readonly reasonString: {
                                    readonly type: "string";
                                };
                                readonly userProperties: {
                                    readonly type: "object";
                                    readonly additionalProperties: {
                                        readonly oneOf: [{
                                            readonly type: "string";
                                        }, {
                                            readonly type: "array";
                                            readonly items: any;
                                        }];
                                    };
                                };
                                readonly wildcardSubscriptionAvailable: {
                                    readonly type: "boolean";
                                };
                                readonly subscriptionIdentifiersAvailable: {
                                    readonly type: "boolean";
                                };
                                readonly sharedSubscriptionAvailable: {
                                    readonly type: "boolean";
                                };
                                readonly serverKeepAlive: {
                                    readonly type: "number";
                                };
                                readonly responseInformation: {
                                    readonly type: "string";
                                };
                                readonly serverReference: {
                                    readonly type: "string";
                                };
                                readonly authenticationMethod: {
                                    readonly type: "string";
                                };
                                readonly authenticationData: {
                                    readonly type: "string";
                                    readonly format: "binary";
                                };
                            };
                            readonly additionalProperties: false;
                        };
                    };
                    readonly additionalProperties: false;
                };
                readonly url: {
                    readonly type: "string";
                };
                readonly connected: {
                    readonly type: "boolean";
                };
            };
            readonly additionalProperties: false;
        };
    };
    error: {
        schema: {
            readonly type: "object";
            readonly properties: {
                readonly error: {
                    readonly type: "string";
                };
            };
            readonly additionalProperties: false;
        };
    };
    'outgoing-packet': {
        schema: {
            readonly type: "object";
            readonly properties: {
                readonly packet: {
                    readonly oneOf: [{
                        readonly type: "object";
                        readonly required: ["cmd"];
                        readonly properties: {
                            readonly cmd: {
                                readonly type: "string";
                                readonly enum: readonly ["puback", "pubcomp", "pubrel", "pubrec"];
                            };
                            readonly messageId: {
                                readonly type: "number";
                            };
                            readonly length: {
                                readonly type: "number";
                            };
                            readonly reasonCode: {
                                readonly type: "number";
                            };
                            readonly properties: {
                                readonly type: "object";
                                readonly properties: {
                                    readonly reasonString: {
                                        readonly type: "string";
                                    };
                                    readonly userProperties: {
                                        readonly type: "object";
                                        readonly additionalProperties: {
                                            readonly oneOf: [any, any];
                                        };
                                    };
                                };
                            };
                        };
                    }, {
                        readonly type: "object";
                        readonly required: ["cmd", "qos", "topic", "payload"];
                        readonly properties: {
                            readonly cmd: {
                                readonly type: "string";
                                readonly const: "publish";
                            };
                            readonly messageId: {
                                readonly type: "number";
                            };
                            readonly length: {
                                readonly type: "number";
                            };
                            readonly qos: {
                                readonly type: "number";
                                readonly enum: readonly [0, 1, 2];
                            };
                            readonly dup: {
                                readonly type: "boolean";
                            };
                            readonly retain: {
                                readonly type: "boolean";
                            };
                            readonly topic: {
                                readonly type: "string";
                            };
                            readonly payload: {
                                readonly type: "string";
                            };
                            readonly message: {
                                readonly oneOf: [{
                                    readonly type: "string";
                                }, {
                                    readonly type: "number";
                                }, {
                                    readonly type: "object";
                                    readonly additionalProperties: true;
                                }];
                            };
                            readonly properties: {
                                readonly type: "object";
                                readonly properties: {
                                    readonly userProperties: {
                                        readonly type: "object";
                                        readonly additionalProperties: {
                                            readonly oneOf: [any, any];
                                        };
                                    };
                                };
                            };
                        };
                    }, {
                        readonly type: "object";
                        readonly required: ["cmd", "granted"];
                        readonly properties: {
                            readonly cmd: {
                                readonly type: "string";
                                readonly const: "suback";
                            };
                            readonly messageId: {
                                readonly type: "number";
                            };
                            readonly length: {
                                readonly type: "number";
                            };
                            readonly properties: {
                                readonly type: "object";
                                readonly properties: {
                                    readonly reasonString: {
                                        readonly type: "string";
                                    };
                                    readonly userProperties: {
                                        readonly type: "object";
                                        readonly additionalProperties: {
                                            readonly oneOf: [any, any];
                                        };
                                    };
                                };
                            };
                            readonly granted: {
                                readonly type: "array";
                                readonly items: {
                                    readonly type: "object";
                                    readonly properties: {
                                        readonly topic: {
                                            readonly type: "string";
                                        };
                                        readonly qos: {
                                            readonly type: "number";
                                        };
                                    };
                                    readonly required: ["topic"];
                                };
                            };
                        };
                    }, {
                        readonly type: "object";
                        readonly required: ["cmd", "granted"];
                        readonly properties: {
                            readonly cmd: {
                                readonly type: "string";
                                readonly const: "unsuback";
                            };
                            readonly properties: {
                                readonly type: "object";
                                readonly properties: {
                                    readonly reasonString: {
                                        readonly type: "string";
                                    };
                                    readonly userProperties: {
                                        readonly type: "object";
                                        readonly additionalProperties: {
                                            readonly oneOf: [any, any];
                                        };
                                    };
                                };
                            };
                            readonly granted: {
                                readonly type: "array";
                                readonly items: {
                                    readonly type: "object";
                                    readonly properties: {
                                        readonly topic: {
                                            readonly type: "string";
                                        };
                                    };
                                    readonly required: ["topic"];
                                };
                            };
                            readonly length: {
                                readonly type: "number";
                            };
                            readonly messageId: {
                                readonly type: "number";
                            };
                        };
                    }, {
                        readonly type: "object";
                        readonly required: ["cmd", "unsubscriptions"];
                        readonly properties: {
                            readonly cmd: {
                                readonly type: "string";
                                readonly const: "unsubscribe";
                            };
                            readonly messageId: {
                                readonly type: "number";
                            };
                            readonly dup: {
                                readonly type: "boolean";
                            };
                            readonly length: {
                                readonly type: "number";
                            };
                            readonly properties: {
                                readonly type: "object";
                                readonly properties: {
                                    readonly reasonString: {
                                        readonly type: "string";
                                    };
                                    readonly userProperties: {
                                        readonly type: "object";
                                        readonly additionalProperties: {
                                            readonly oneOf: [any, any];
                                        };
                                    };
                                };
                            };
                            readonly unsubscriptions: {
                                readonly type: "array";
                                readonly items: {
                                    readonly type: "string";
                                };
                            };
                        };
                    }, {
                        readonly type: "object";
                        readonly required: ["cmd", "subscriptions"];
                        readonly additionalProperties: false;
                        readonly properties: {
                            readonly cmd: {
                                readonly type: "string";
                                readonly const: "subscribe";
                            };
                            readonly messageId: {
                                readonly type: "number";
                            };
                            readonly length: {
                                readonly type: "number";
                            };
                            readonly subscriptions: {
                                readonly type: "array";
                                readonly items: {
                                    readonly type: "object";
                                    readonly additionalProperties: false;
                                    readonly required: ["topic", "qos"];
                                    readonly properties: {
                                        readonly topic: {
                                            readonly type: "string";
                                        };
                                        readonly qos: {
                                            readonly type: "number";
                                            readonly enum: readonly [0, 1, 2];
                                        };
                                        readonly nl: {
                                            readonly type: "boolean";
                                        };
                                        readonly rap: {
                                            readonly type: "boolean";
                                        };
                                        readonly rh: {
                                            readonly type: "number";
                                        };
                                    };
                                };
                            };
                            readonly properties: {
                                readonly type: "object";
                                readonly properties: {
                                    readonly reasonString: {
                                        readonly type: "string";
                                    };
                                    readonly userProperties: {
                                        readonly type: "object";
                                        readonly additionalProperties: {
                                            readonly oneOf: [any, any];
                                        };
                                    };
                                };
                            };
                        };
                    }];
                };
            };
            readonly additionalProperties: false;
        };
    };
    'incoming-packet': {
        schema: {
            readonly type: "object";
            readonly properties: {
                readonly packet: {
                    readonly oneOf: [{
                        readonly type: "object";
                        readonly required: ["cmd"];
                        readonly properties: {
                            readonly cmd: {
                                readonly type: "string";
                                readonly enum: readonly ["puback", "pubcomp", "pubrel", "pubrec"];
                            };
                            readonly messageId: {
                                readonly type: "number";
                            };
                            readonly length: {
                                readonly type: "number";
                            };
                            readonly reasonCode: {
                                readonly type: "number";
                            };
                            readonly properties: {
                                readonly type: "object";
                                readonly properties: {
                                    readonly reasonString: {
                                        readonly type: "string";
                                    };
                                    readonly userProperties: {
                                        readonly type: "object";
                                        readonly additionalProperties: {
                                            readonly oneOf: [any, any];
                                        };
                                    };
                                };
                            };
                        };
                        readonly additionalProperties: false;
                    }, {
                        readonly type: "object";
                        readonly required: ["cmd", "qos", "topic", "payload"];
                        readonly properties: {
                            readonly cmd: {
                                readonly type: "string";
                                readonly const: "publish";
                            };
                            readonly messageId: {
                                readonly type: "number";
                            };
                            readonly length: {
                                readonly type: "number";
                            };
                            readonly qos: {
                                readonly type: "number";
                                readonly enum: readonly [0, 1, 2];
                            };
                            readonly dup: {
                                readonly type: "boolean";
                            };
                            readonly retain: {
                                readonly type: "boolean";
                            };
                            readonly topic: {
                                readonly type: "string";
                            };
                            readonly payload: {
                                readonly type: "string";
                            };
                            readonly message: {
                                readonly oneOf: [{
                                    readonly type: "string";
                                }, {
                                    readonly type: "number";
                                }, {
                                    readonly type: "object";
                                    readonly additionalProperties: true;
                                }];
                            };
                            readonly properties: {
                                readonly type: "object";
                                readonly properties: {
                                    readonly userProperties: {
                                        readonly type: "object";
                                        readonly additionalProperties: {
                                            readonly oneOf: [any, any];
                                        };
                                    };
                                };
                            };
                        };
                        readonly additionalProperties: false;
                    }, {
                        readonly type: "object";
                        readonly required: ["cmd", "granted"];
                        readonly properties: {
                            readonly cmd: {
                                readonly type: "string";
                                readonly const: "suback";
                            };
                            readonly messageId: {
                                readonly type: "number";
                            };
                            readonly length: {
                                readonly type: "number";
                            };
                            readonly properties: {
                                readonly type: "object";
                                readonly properties: {
                                    readonly reasonString: {
                                        readonly type: "string";
                                    };
                                    readonly userProperties: {
                                        readonly type: "object";
                                        readonly additionalProperties: {
                                            readonly oneOf: [any, any];
                                        };
                                    };
                                };
                            };
                            readonly granted: {
                                readonly type: "array";
                                readonly items: {
                                    readonly type: "object";
                                    readonly properties: {
                                        readonly topic: {
                                            readonly type: "string";
                                        };
                                        readonly qos: {
                                            readonly type: "number";
                                        };
                                    };
                                    readonly required: ["topic"];
                                };
                            };
                        };
                    }, {
                        readonly type: "object";
                        readonly required: ["cmd", "granted"];
                        readonly properties: {
                            readonly cmd: {
                                readonly type: "string";
                                readonly const: "unsuback";
                            };
                            readonly properties: {
                                readonly type: "object";
                                readonly properties: {
                                    readonly reasonString: {
                                        readonly type: "string";
                                    };
                                    readonly userProperties: {
                                        readonly type: "object";
                                        readonly additionalProperties: {
                                            readonly oneOf: [any, any];
                                        };
                                    };
                                };
                            };
                            readonly granted: {
                                readonly type: "array";
                                readonly items: {
                                    readonly type: "object";
                                    readonly properties: {
                                        readonly topic: {
                                            readonly type: "string";
                                        };
                                    };
                                    readonly required: ["topic"];
                                };
                            };
                            readonly length: {
                                readonly type: "number";
                            };
                            readonly messageId: {
                                readonly type: "number";
                            };
                        };
                    }, {
                        readonly type: "object";
                        readonly required: ["cmd", "unsubscriptions"];
                        readonly properties: {
                            readonly cmd: {
                                readonly type: "string";
                                readonly const: "unsubscribe";
                            };
                            readonly messageId: {
                                readonly type: "number";
                            };
                            readonly dup: {
                                readonly type: "boolean";
                            };
                            readonly length: {
                                readonly type: "number";
                            };
                            readonly properties: {
                                readonly type: "object";
                                readonly properties: {
                                    readonly reasonString: {
                                        readonly type: "string";
                                    };
                                    readonly userProperties: {
                                        readonly type: "object";
                                        readonly additionalProperties: {
                                            readonly oneOf: [any, any];
                                        };
                                    };
                                };
                            };
                            readonly unsubscriptions: {
                                readonly type: "array";
                                readonly items: {
                                    readonly type: "string";
                                };
                            };
                        };
                    }, {
                        readonly type: "object";
                        readonly required: ["cmd", "subscriptions"];
                        readonly properties: {
                            readonly cmd: {
                                readonly type: "string";
                                readonly const: "subscribe";
                            };
                            readonly messageId: {
                                readonly type: "number";
                            };
                            readonly length: {
                                readonly type: "number";
                            };
                            readonly subscriptions: {
                                readonly type: "array";
                                readonly items: {
                                    readonly type: "object";
                                    readonly required: ["topic", "qos"];
                                    readonly properties: {
                                        readonly topic: {
                                            readonly type: "string";
                                        };
                                        readonly qos: {
                                            readonly type: "number";
                                            readonly enum: readonly [0, 1, 2];
                                        };
                                        readonly nl: {
                                            readonly type: "boolean";
                                        };
                                        readonly rap: {
                                            readonly type: "boolean";
                                        };
                                        readonly rh: {
                                            readonly type: "number";
                                        };
                                    };
                                };
                            };
                            readonly properties: {
                                readonly type: "object";
                                readonly properties: {
                                    readonly reasonString: {
                                        readonly type: "string";
                                    };
                                    readonly userProperties: {
                                        readonly type: "object";
                                        readonly additionalProperties: {
                                            readonly oneOf: [any, any];
                                        };
                                    };
                                };
                            };
                        };
                    }];
                };
                readonly contentType: {
                    readonly type: "string";
                };
            };
            readonly additionalProperties: false;
        };
    };
    'transport:ws:connected': {
        schema: {
            readonly type: "object";
            readonly properties: {
                readonly handshakeRequest: {
                    readonly type: "object";
                    readonly required: ["method", "headers"];
                    readonly properties: {
                        readonly method: {
                            readonly type: "string";
                            readonly enum: readonly ["GET", "CONNECT"];
                        };
                        readonly headers: {
                            readonly type: "array";
                            readonly items: {
                                readonly type: "object";
                                readonly required: ["key", "value"];
                                readonly properties: {
                                    readonly key: {
                                        readonly type: "string";
                                    };
                                    readonly value: {
                                        readonly type: "string";
                                    };
                                };
                                readonly additionalProperties: false;
                            };
                        };
                    };
                    readonly additionalProperties: false;
                };
                readonly handshakeResponse: {
                    readonly type: "object";
                    readonly required: ["statusCode", "statusMessage", "headers"];
                    readonly properties: {
                        readonly statusCode: {
                            readonly type: "integer";
                            readonly minimum: 100;
                            readonly maximum: 599;
                        };
                        readonly statusMessage: {
                            readonly type: "string";
                        };
                        readonly headers: {
                            readonly type: "array";
                            readonly items: {
                                readonly type: "object";
                                readonly required: ["key", "value"];
                                readonly properties: {
                                    readonly key: {
                                        readonly type: "string";
                                    };
                                    readonly value: {
                                        readonly type: "string";
                                    };
                                };
                                readonly additionalProperties: false;
                            };
                        };
                    };
                    readonly additionalProperties: false;
                };
            };
            readonly additionalProperties: false;
        };
    };
    'transport:ws:disconnected': {
        schema: {
            readonly type: "object";
            readonly properties: {
                readonly code: {
                    readonly type: "integer";
                    readonly minimum: 1000;
                    readonly maximum: 4999;
                };
                readonly reason: {
                    readonly type: "string";
                };
            };
            readonly additionalProperties: false;
        };
    };
    'transport:ws:error': {
        schema: {
            readonly type: "object";
            readonly required: ["error"];
            readonly properties: {
                readonly error: {
                    readonly type: "object";
                    readonly required: ["message"];
                    readonly properties: {
                        readonly message: {
                            readonly type: "string";
                        };
                    };
                    readonly additionalProperties: false;
                };
                readonly handshakeRequest: {
                    readonly type: "object";
                    readonly required: ["method", "headers"];
                    readonly properties: {
                        readonly method: {
                            readonly type: "string";
                            readonly enum: readonly ["GET", "CONNECT"];
                        };
                        readonly headers: {
                            readonly type: "array";
                            readonly items: {
                                readonly type: "object";
                                readonly required: ["key", "value"];
                                readonly properties: {
                                    readonly key: {
                                        readonly type: "string";
                                    };
                                    readonly value: {
                                        readonly type: "string";
                                    };
                                };
                                readonly additionalProperties: false;
                            };
                        };
                    };
                    readonly additionalProperties: false;
                };
                readonly handshakeResponse: {
                    readonly type: "object";
                    readonly required: ["statusCode", "statusMessage", "headers"];
                    readonly properties: {
                        readonly statusCode: {
                            readonly type: "integer";
                            readonly minimum: 100;
                            readonly maximum: 599;
                        };
                        readonly statusMessage: {
                            readonly type: "string";
                        };
                        readonly headers: {
                            readonly type: "array";
                            readonly items: {
                                readonly type: "object";
                                readonly required: ["key", "value"];
                                readonly properties: {
                                    readonly key: {
                                        readonly type: "string";
                                    };
                                    readonly value: {
                                        readonly type: "string";
                                    };
                                };
                                readonly additionalProperties: false;
                            };
                        };
                    };
                    readonly additionalProperties: false;
                };
            };
            readonly additionalProperties: false;
        };
    };
    disconnected: {
        schema: {
            readonly type: "object";
            readonly properties: {
                readonly message: {
                    readonly type: "string";
                };
                readonly packet: {
                    readonly type: "object";
                    readonly properties: {
                        readonly cmd: {
                            readonly type: "string";
                            readonly enum: readonly ["disconnect"];
                        };
                        readonly reasonCode: {
                            readonly type: "number";
                        };
                        readonly properties: {
                            readonly type: "object";
                            readonly properties: {
                                readonly sessionExpiryInterval: {
                                    readonly type: "number";
                                };
                                readonly reasonString: {
                                    readonly type: "string";
                                };
                                readonly userProperties: {
                                    readonly type: "object";
                                    readonly additionalProperties: {
                                        readonly oneOf: [{
                                            readonly type: "string";
                                        }, {
                                            readonly type: "array";
                                            readonly items: any;
                                        }];
                                    };
                                };
                                readonly serverReference: {
                                    readonly type: "string";
                                };
                            };
                            readonly additionalProperties: false;
                        };
                    };
                    readonly required: ["cmd"];
                    readonly additionalProperties: false;
                };
            };
            readonly additionalProperties: false;
        };
    };
    reconnecting: {
        schema: {
            readonly type: "object";
            readonly additionalProperties: false;
        };
    };
    aborted: {
        schema: {
            readonly type: "object";
            readonly additionalProperties: false;
        };
    };
};
export type Connected = Event<'connected', FromSchema<(typeof definition)['connected']['schema']>>;
export type Error = Event<'error', FromSchema<(typeof definition)['error']['schema']>>;
export type OutgoingPacket = Event<'outgoing-packet', FromSchema<(typeof definition)['outgoing-packet']['schema']>>;
export type IncomingPacket = Event<'incoming-packet', FromSchema<(typeof definition)['incoming-packet']['schema']>>;
export type TransportWSConnected = Event<'transport:ws:connected', FromSchema<(typeof definition)['transport:ws:connected']['schema']>>;
export type TransportWSError = Event<'transport:ws:error', FromSchema<(typeof definition)['transport:ws:error']['schema']>>;
export type TransportWSDisconnected = Event<'transport:ws:disconnected', FromSchema<(typeof definition)['transport:ws:disconnected']['schema']>>;
export type Disconnected = Event<'disconnected', FromSchema<(typeof definition)['disconnected']['schema']>>;
export type Reconnecting = Event<'reconnecting', FromSchema<(typeof definition)['reconnecting']['schema']>>;
export type Aborted = Event<'aborted', FromSchema<(typeof definition)['aborted']['schema']>>;
export type Publish = Event<'publish', MqttMessage>;
export type Subscribe = Event<'subscribe', SubscriptionMessage>;
export type Unsubscribe = Event<'unsubscribe', {
    topic: string;
}>;
export type Disconnect = Event<'disconnect'>;
export type Cancel = Event<'cancel'>;
export {};
