/// <reference types="node" />
import { ParsedURL } from '@postman/runtime.mqtt-utils';
import { MQTTClientOptions } from './client';
export type ConnectionOptions = Omit<MQTTClientOptions, 'cleanSession' | 'properties' | 'version'> & {
    protocol: ParsedURL['protocol'];
    protocolVersion?: 4 | 5;
    clean: boolean;
    properties?: {
        sessionExpiryInterval?: number;
        receiveMaximum?: number;
        maximumPacketSize?: number;
        userProperties?: UserProperties;
    };
    will?: Omit<MQTTClientOptions['lastWill'], 'properties' | 'payload'> & {
        topic: string;
        payload: Buffer;
        properties?: {
            payloadFormatIndicator?: boolean;
            messageExpiryInterval?: number;
            willDelayInterval?: number;
            responseTopic?: string;
            correlationData?: Buffer;
            contentType?: string;
            userProperties?: UserProperties;
        };
    };
};
export type UserProperties = Record<string, string>;
export declare function validateSettings(url: ParsedURL, mqttOptions: MQTTClientOptions | null | undefined): ConnectionOptions;
export declare function transformUserProperties(userProperties?: Array<{
    key: string;
    value: string | boolean | number;
    disabled?: boolean;
}>): UserProperties;
