declare const template = "\n\tconst Ajv = require('ajv');\n\tconst chai = require('chai');\n\tconst _ = require('lodash');\n\tconst { Property, PropertyList, RequestAuth, Url } = require('postman-collection');\n\n\tclass Metadata extends Property {\n\t\tconstructor (options = {}) {\n\t\t\tsuper(options);\n\n\t\t\tthis.key = options.key;\n\t\t\tthis.value = options.value;\n\t\t\tthis.disabled = options.disabled;\n\t\t}\n\n\t\ttoString () {\n\t\t\treturn this.key + ': ' + this.value;\n\t\t}\n\n\t\tvalueOf () {\n\t\t\treturn this.value;\n\t\t}\n\n\t\tstatic _postman_propertyIndexKey = 'key';\n\t\tstatic _postman_propertyIndexCaseInsensitive = true;\n\t\tstatic _postman_propertyAllowsMultipleValues = true;\n\n\t\tstatic parse (metadataString) {\n\t\t\tconst metadata = [],\n\t\t\t\tregexes = {\n\t\t\t\t\tmetadata: /^(\\S+):(.*)$/gm,\n\t\t\t\t\tfold: /\\r\\n([ \\t])/g,\n\t\t\t\t\ttrim: /^\\s*(.*\\S)?\\s*$/\n\t\t\t\t};\n\t\t\tlet match = regexes.metadata.exec(metadataString);\n\n\t\t\tmetadataString = metadataString.toString().replace(regexes.fold, '$1');\n\n\t\t\twhile (match) {\n\t\t\t\tmetadata.push({\n\t\t\t\t\tkey: match[1],\n\t\t\t\t\tvalue: match[2].replace(regexes.trim, '$1')\n\t\t\t\t});\n\t\t\t\tmatch = regexes.metadata.exec(metadataString);\n\t\t\t}\n\n\t\t\treturn metadata;\n\t\t}\n\n\t\tstatic parseSingle (metadata) {\n\t\t\tif (!_.isString(metadata)) { return { key: '', value: '' }; }\n\n\t\t\tlet index = metadata.indexOf(':');\n\t\t\t(index < 0) && (index = metadata.length);\n\n\t\t\tconst key = metadata.substr(0, index),\n\t\t\t\tvalue = metadata.substr(index + 1);\n\n\t\t\treturn {\n\t\t\t\tkey: _.trim(key),\n\t\t\t\tvalue: _.trim(value)\n\t\t\t};\n\t\t}\n\n\t\tstatic unparse (metadata, separator = '\\r\\n') {\n\t\t\tif (!_.isArray(metadata) && !PropertyList.isPropertyList(metadata)) {\n\t\t\t\treturn '';\n\t\t\t}\n\n\t\t\treturn metadata.reduce((acc, m) => {\n\t\t\t\tif (m && !m.disabled) {\n\t\t\t\t\tacc += Metadata.unparseSingle(m) + separator;\n\t\t\t\t}\n\n\t\t\t\treturn acc;\n\t\t\t}, '');\n\t\t}\n\n\t\tstatic unparseSingle (metadata) {\n\t\t\tif (!_.isObject(metadata)) { return ''; }\n\n\t\t\treturn metadata.key + ': ' + metadata.value;\n\t\t}\n\t}\n\n\tclass Message extends Property {\n\t\tconstructor(options = {}) {\n\t\t\tsuper(options);\n\n\t\t\tthis.data = options.data;\n\n\t\t\tif (!_.isNil(options.timestamp)) {\n\t\t\t\tthis.timestamp = new Date(options.timestamp);\n\t\t\t}\n\t\t}\n\n\t\ttoString () {\n\t\t\treturn JSON.stringify(this.data);\n\t\t}\n\n\t\tvalueOf () {\n\t\t\treturn this.data;\n\t\t}\n\t}\n\n\tconst messageTo = {\n\t\tget () {\n\t\t\tconst assertion = chai.expect(this.members.map(m => m.data));\n\n\t\t\tchai.util.flag(assertion, 'messageList', true);\n\n\t\t\treturn assertion.to;\n\t\t}\n\t};\n\n\tfunction prepareMessages (messages) {\n\t\treturn messages ? messages.map((message) => new Message(message)) : [];\n\t}\n\n\tclass Request extends Property {\n\t\tconstructor(options = {}) {\n\t\t\tsuper(options);\n\n\t\t\tthis.url = new Url(options.url);\n\t\t\tthis.methodPath = options.methodPath;\n\t\t\tthis.auth = new RequestAuth(options.auth);\n\t\t\tthis.metadata = new PropertyList(Metadata, this, options.metadata);\n\t\t\tthis.messages = new PropertyList(Message, this, prepareMessages(options.messages));\n\n\t\t\tthis.messages._postman_proprtyIsSerialisedAsPlural = true;\n\n\t\t\tObject.defineProperty(this.messages, 'to', messageTo);\n\t\t}\n\n\t\tstatic isRequest (obj) {\n\t\t\treturn (obj instanceof Request);\n\t\t}\n\t}\n\n\tclass Response extends Property {\n\t\tconstructor(options = {}) {\n\t\t\tsuper(options);\n\n\t\t\tthis.statusCode = options.statusCode;\n\t\t\tthis.responseTime = options.responseTime;\n\t\t\tthis.metadata = new PropertyList(Metadata, this, options.metadata);\n\t\t\tthis.trailers = new PropertyList(Metadata, this, options.trailers);\n\t\t\tthis.messages = new PropertyList(Message, this, prepareMessages(options.messages));\n\n\t\t\tthis.messages._postman_proprtyIsSerialisedAsPlural = true;\n\n\t\t\tObject.defineProperty(this.messages, 'to', messageTo);\n\t\t}\n\n\t\tstatic isResponse (obj) {\n\t\t\treturn (obj instanceof Response);\n\t\t}\n\t}\n\n\tfunction initializeExecution (target, context) {\n\t\tswitch (target) {\n\t\t\tcase 'beforeInvoke':\n\t\t\t\treturn {\n\t\t\t\t\trequest: new Request(context.request)\n\t\t\t\t};\n\n\t\t\tcase 'afterResponse':\n\t\t\t\treturn {\n\t\t\t\t\trequest: new Request(context.request),\n\t\t\t\t\tresponse: new Response(context.response)\n\t\t\t\t};\n\t\t}\n\t}\n\n\tfunction chaiPlugin (chai) {\n\t\tconst Assertion = chai.Assertion;\n\n\t\tAssertion.addProperty('postmanRequest', function () {\n\t\t\tthis.assert(Request.isRequest(this._obj),\n\t\t\t\t'expecting a postman request object but got #{this}',\n\t\t\t\t'not expecting a postman request object');\n\t\t});\n\n\t\tAssertion.addProperty('postmanResponse', function () {\n\t\t\tthis.assert(Response.isResponse(this._obj),\n\t\t\t\t'expecting a postman response object but got #{this}',\n\t\t\t\t'not expecting a postman response object');\n\t\t});\n\n\t\tAssertion.addProperty('postmanRequestOrResponse', function () {\n\t\t\tthis.assert(Response.isResponse(this._obj) || Request.isRequest(this._obj),\n\t\t\t\t'expecting a postman request or response object but got #{this}',\n\t\t\t\t'not expecting a postman request or response object');\n\t\t});\n\n\t\tAssertion.addProperty('ok', function () {\n\t\t\t// If asserted object is not response, use underlying 'ok'\n\t\t\tif (!Response.isResponse(this._obj)) {\n\t\t\t\tthis.assert(chai.util.flag(this, 'object'),\n\t\t\t\t\t'expected #{this} to be truthy',\n\t\t\t\t\t'expected #{this} to be falsy');\n\n\t\t\t\treturn;\n\t\t\t}\n\n\t\t\tconst expectedStatusCode = 0;\n\t\t\tconst actualStatusCode = this._obj.statusCode;\n\n\t\t\tthis.assert(actualStatusCode === expectedStatusCode,\n\t\t\t\t'expected response to have status code #{exp} but got #{act}',\n\t\t\t\t'expected response to not have status code #{act}',\n\t\t\t\texpectedStatusCode, actualStatusCode);\n\t\t});\n\n\t\tAssertion.addMethod('statusCode', function (statusCode) {\n\t\t\tnew Assertion(this._obj).to.be.postmanResponse;\n\n\t\t\tthis.assert(this._obj.statusCode === statusCode,\n\t\t\t\t'expected response to have status code #{exp} but got #{act}',\n\t\t\t\t'expected response to not have status code #{act}',\n\t\t\t\tstatusCode, this._obj.statusCode);\n\t\t});\n\n\t\tAssertion.addMethod('metadata', function (mKey, mValue) {\n\t\t\tnew Assertion(this._obj).to.be.postmanRequestOrResponse;\n\t\t\tnew Assertion(this._obj).to.have.property('metadata');\n\n\t\t\tconst ror = Request.isRequest(this._obj) ? 'request' : 'response';\n\n\t\t\tthis.assert(this._obj.metadata.has(mKey),\n\t\t\t\t\"expected \" + ror + \" to have metadata with key '\" + mKey + \"'\",\n\t\t\t\t\"expected \" + ror + \" to not have metadata with key '\" + mKey + \"'\",\n\t\t\t\ttrue, this._obj.metadata.has(mKey));\n\n\t\t\t// In case no check is done on value\n\t\t\tif (arguments.length < 2) { return; }\n\n\t\t\tthis.assert(this._obj.metadata.one(mKey).value === mValue,\n\t\t\t\t\"expected '\" + mKey + \"' \" + ror + \" metadata to be #{exp} but got #{act}\",\n\t\t\t\t\"expected '\" + mKey + \"' \" + ror + \" metadata to not be #{act}\",\n\t\t\t\tmValue, this._obj.metadata.one(mKey).value);\n\t\t});\n\n\t\tAssertion.addMethod('trailer', function (tKey, tValue) {\n\t\t\tnew Assertion(this._obj).to.be.postmanResponse;\n\t\t\tnew Assertion(this._obj).to.have.property('trailers');\n\n\t\t\tthis.assert(this._obj.trailers.has(tKey),\n\t\t\t\t\"expected response to have trailer with key '\" + tKey + \"'\",\n\t\t\t\t\"expected response to not have trailer with key '\" + tKey + \"'\",\n\t\t\t\ttrue, this._obj.trailers.has(tKey));\n\n\t\t\t// In case no check is done on value\n\t\t\tif (arguments.length < 2) { return; }\n\n\t\t\tthis.assert(this._obj.trailers.one(tKey).value === tValue,\n\t\t\t\t\"expected '\" + tKey + \"' response trailer to be #{exp} but got #{act}\",\n\t\t\t\t\"expected '\" + tKey + \"' response trailer to not be #{act}\",\n\t\t\t\ttValue, this._obj.trailers.one(tKey).value);\n\t\t});\n\n\t\tAssertion.addChainableMethod('responseTime', function (value) {\n\t\t\tconst actualTime = chai.util.flag(this, 'number');\n\n\t\t\tnew Assertion(actualTime).to.be.a('number');\n\n\t\t\targuments.length && this.assert(actualTime === value,\n\t\t\t\t'expected response time to be #{exp} but got #{act}',\n\t\t\t\t'expected response time to not be #{act}', value, actualTime);\n\t\t}, function () {\n\t\t\tnew Assertion(this._obj).to.be.postmanResponse;\n\t\t\tnew Assertion(this._obj).to.have.property('responseTime').a('number');\n\n\t\t\tchai.util.flag(this, 'number', this._obj.responseTime);\n\t\t\tthis._obj = this._obj.responseTime;\n\t\t});\n\n\t\tAssertion.addMethod('jsonSchema', function (schema, options) {\n\t\t\tnew Assertion(schema).to.be.an('object');\n\n\t\t\tconst ajvOptions = {\n\t\t\t\tallErrors: true,\n\t\t\t\tlogger: false,\n\t\t\t\t...options\n\t\t\t};\n\t\t\tconst isMessageList = chai.util.flag(this, 'messageList');\n\n\t\t\tif (isMessageList) {\n\t\t\t\tthis._obj.forEach((msg) => {\n\t\t\t\t\tconst ajv = new Ajv(ajvOptions);\n\t\t\t\t\tconst valid = ajv.validate(schema, msg);\n\n\t\t\t\t\tthis.assert(\n\t\t\t\t\t\tvalid && !ajv.errors,\n\t\t\t\t\t\t\"expected message(s) to satisfy schema but found following errors: \\n\" + ajv.errorsText(),\n\t\t\t\t\t\t\"expected message(s) to not satisfy schema\",\n\t\t\t\t\t\ttrue,\n\t\t\t\t\t\tvalid\n\t\t\t\t\t);\n\t\t\t\t});\n\t\t\t} else {\n\t\t\t\tconst ajv = new Ajv(ajvOptions);\n\t\t\t\tconst valid = ajv.validate(schema, this._obj);\n\n\t\t\t\tthis.assert(\n\t\t\t\t\tvalid && !ajv.errors,\n\t\t\t\t\t\"expected object to satisfy the schema but found following errors: \\n\" + ajv.errorsText(),\n\t\t\t\t\t\"expected object to not satisfy the schema\",\n\t\t\t\t\ttrue,\n\t\t\t\t\tvalid\n\t\t\t\t);\n\t\t\t}\n\t\t});\n\n\t\tAssertion.addMethod('message', function (value) {\n\t\t\tnew Assertion(this._obj).to.be.postmanRequestOrResponse;\n\t\t\tnew Assertion(this._obj).to.have.property('messages');\n\t\t\tnew Assertion(value).to.be.a('object');\n\n\t\t\tthis.assert(\n\t\t\t\t_.some(this._obj.messages.members, (msg) => _.isEqual(msg.data, value)),\n\t\t\t\t'expected message(s) to have #{exp}',\n\t\t\t\t'expected message(s) to not have #{exp}',\n\t\t\t\tvalue,\n\t\t\t\tnull\n\t\t\t);\n\t\t});\n\n\t\tAssertion.overwriteMethod('property', function (_super) {\n\t\t\treturn function (key, value) {\n\t\t\t\tconst isMessageList = chai.util.flag(this, 'messageList');\n\n\t\t\t\tif (isMessageList) {\n\t\t\t\t\tnew Assertion(key).to.be.a('string');\n\n\t\t\t\t\tconst args = [key];\n\n\t\t\t\t\targuments.length === 2 && args.push(value);\n\n\t\t\t\t\tthis._obj.forEach((msg) => new Assertion(msg).to.have.deep.nested.property(...args));\n\t\t\t\t} else {\n\t\t\t\t\t_super.apply(this, arguments);\n\t\t\t\t}\n\t\t\t};\n\t\t});\n\n\t\tAssertion.overwriteChainableMethod('include', function (_super) {\n\t\t\treturn function (value) {\n\t\t\t\tconst isMessageList = chai.util.flag(this, 'messageList');\n\n\t\t\t\tif (isMessageList) {\n\t\t\t\t\tnew Assertion(value).to.be.a('object');\n\n\t\t\t\t\tthis.assert(\n\t\t\t\t\t\t_.some(this._obj, value),\n\t\t\t\t\t\t'expected some messages to include #{exp}',\n\t\t\t\t\t\t'expected some messages to not include #{exp}',\n\t\t\t\t\t\tvalue,\n\t\t\t\t\t\tnull\n\t\t\t\t\t);\n\t\t\t\t} else {\n\t\t\t\t\t_super.apply(this, arguments);\n\t\t\t\t}\n\t\t\t};\n\t\t}, function (_super) {\n\t\t\treturn function () {\n\t\t\t\t_super.apply(this, arguments);\n\t\t\t};\n\t\t});\n\t}\n\n\tmodule.exports = {\n\t\tinitializeExecution,\n\t\tchaiPlugin\n\t};\n";
export default template;
