import { InnerClient } from "./core.js";
import * as types from "./types.js";
import { SdkIterable } from "./iterator.js";
/**
 *  The Items API holds all operations the SDK client can perform on 1Password items.
 */
export interface ItemsApi {
    /**
     *  Create a new item
     */
    create(params: types.ItemCreateParams): Promise<types.Item>;
    /**
     *  Get an item by vault and item ID
     */
    get(vaultId: string, itemId: string): Promise<types.Item>;
    /**
     *  Update an existing item.
     */
    put(item: types.Item): Promise<types.Item>;
    /**
     *  Delete an item.
     */
    delete(vaultId: string, itemId: string): Promise<void>;
    /**
     *  List all items
     */
    listAll(vaultId: string): Promise<SdkIterable<types.ItemOverview>>;
}
export declare class ItemsSource implements ItemsApi {
    #private;
    constructor(inner: InnerClient);
    /**
     *  Create a new item
     */
    create(params: types.ItemCreateParams): Promise<types.Item>;
    /**
     *  Get an item by vault and item ID
     */
    get(vaultId: string, itemId: string): Promise<types.Item>;
    /**
     *  Update an existing item.
     */
    put(item: types.Item): Promise<types.Item>;
    /**
     *  Delete an item.
     */
    delete(vaultId: string, itemId: string): Promise<void>;
    /**
     *  List all items
     */
    listAll(vaultId: string): Promise<SdkIterable<types.ItemOverview>>;
}
