# Migration from 0.4 to 0.5

Welcome! If you're here, it's probably that the migration from 0.4.x to 0.5
didn't go smoothly for you. Don't worry, we can fix that.

## Multiple users with the same email

This is the most common case. You can see in the LLDAP logs that there are
several users with the same email, and they are listed.

This is not allowed anymore in v0.5, to prevent a user from setting their email
to someone else's email and gaining access to systems that identify by email.

The problem is that you currently have several users with the same email, so the
constraint cannot be enforced.

### Step 1: Take a note of the users with duplicate emails

In the LLDAP logs when you tried to start v0.5+, you'll see some warnings with
the list of users with the same emails. Take note of them.

### Step 2: Downgrade to v0.4.3

If using docker, switch to the `lldap/lldap:v0.4.3` image. Alternatively, grab
the binaries at https://github.com/lldap/lldap/releases/tag/v0.4.3.

This downgrade is safe and supported.

### Step 3: Remove duplicate emails

Restart LLDAP with the v0.4.3 version, and using your notes from step 1, change
the email of users with duplicate emails to make sure that each email is unique.

### Step 4: Upgrade again

You can now revert to the initial version.

## Multiple users/groups with the same UUID

This should be extremely rare. In this case, you'll need to find which users
have the same UUID, revert to v0.4.3 to be able to apply the changes, and delete
one of the duplicates.

## FAQ

### What if I want several users to be controlled by the same email?

You can use plus codes to set "the same" email to several users, while ensuring
that they can't identify as each other. For instance:

 - Admin: `admin@example.com`
 - Read-only admin: `admin+readonly@example.com`
 - Jellyfin admin: `admin+jellyfin@example.com`

### I'm upgrading to a higher version than v0.5.

This guide is still relevant: you can use whatever later version in place of
v0.5. You'll still need to revert to v0.4.3 to apply the changes.
